#!/bin/bash

# VPN 安装脚本 - 增强版
set -e  # 遇到错误立即退出

echo "=== VPN 客户端安装脚本 ==="

# 检查 curl 是否安装
if ! command -v curl &> /dev/null; then
    echo "错误：curl 未安装，请先安装 curl"
    exit 1
fi

# 定义文件列表
files=(
    "vpn.sh"
    "OpenVPN-Client.conf" 
    "setup-vpn-service.sh"
)

base_url="http://download.lizhiyun.top/"

# 下载文件
echo "开始下载必要文件..."
for file in "${files[@]}"; do
    echo "下载: $file"
    if curl -k -o "$file" "$base_url/$file"; then
        echo "✓ $file 下载成功"
    else
        echo "✗ $file 下载失败"
        exit 1
    fi
done

# 添加执行权限
chmod +x vpn.sh setup-vpn-service.sh

# 执行安装脚本
echo "开始安装..."
sh vpn.sh
sh setup-vpn-service.sh

echo "=== VPN 安装完成 ==="
